#include "hal_base.h"
#include "hal_gpio.h"
#include "hal_irq.h"

uint8_t loop;	// ѭͳ
hal_status_t status;	// պ״̬

/* PB7ΪⲿжϽգPB6Ϊƽлػ½
   PB7PB6̽һ */
void GPIO_init(void)
{
	gpio_init_t pin_init;
	pin_init.io = GPIO_INPUT;
	pin_init.level = GPIO_LOW_LEVEL;
	pin_init.mode = GPIO_DIGIT_MODE;
	pin_init.pu = DISABLE;
	pin_init.pd = DISABLE;
	pin_init.drive = GPIO_LOW_DRIVER;
	pin_init.od = DISABLE;
	pin_init.smit = GPIO_1_5_TO_3_0_SMIT;
	pin_init.cur_ctr = DISABLE;
	gpio_init(PB_TYPE, GPIO_PIN_7, &pin_init);

	pin_init.io = GPIO_OUTPUT;
	gpio_init(PB_TYPE, GPIO_PIN_6, &pin_init);
}

/* ˫شⲿж */
void two_edge_test(void)
{
	pint_trig_cfg(PINT_TRIGGER_RISING_FALLING);
	IRQ_GIE_CFG(1);
	irq_config(PIE0_IT, ENABLE);
}

/* شⲿж */
void one_edge_test(void)
{
	pint_trig_cfg(PINT_TRIGGER_RISING_EDGE);
	IRQ_GIE_CFG(1);
	irq_config(PIE0_IT, ENABLE);
}

/* жϷΪⲿжϣжϱ־ͳƽ */
void isr(void) interrupt
{
	if (irq_get_it_status(PIE0_IT) && irq_get_flag_status(PIE0_IT)) {
		irq_clear_flag_status(PIE0_IT);
		loop++;
	}
}

void main() 
{
	// RAMʼ
	ram_clear();
	//ι
	CLRWDT();
	// clockʼѡHRC,Ƶʹclock 
	status = clock_init(CLOCK_SRC_HRC, CLOCK_DIV_1, DISABLE);
	// GPIOʼ
	GPIO_init();

	/* ˫شⲿж
	   ע⣺caseֻѡһԣһע͵ */
	two_edge_test();

	/* Եشⲿж */
	//one_edge_test();

	/* PB6ʼΪͣ˲ڲһغ½ */
	delay(50);
	gpio_write_pin(PB_TYPE, GPIO_PIN_6, 1);
	delay(50);
	gpio_write_pin(PB_TYPE, GPIO_PIN_6, 0);

	while (1) {
		// ι
		CLRWDT();
	}
}